/*
 * Decompiled with CFR 0.152.
 */
package com.eevolution.model;

import com.eevolution.model.X_S_Contract;
import com.eevolution.model.X_S_ContractLine;
import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import org.adempiere.core.domains.models.X_M_DiscountSchemaBreak;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MDiscountSchema;
import org.compiere.model.MDiscountSchemaBreak;
import org.compiere.model.MDocType;
import org.compiere.model.MPeriod;
import org.compiere.model.MProductCategory;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocOptions;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.openup.core.model.MFamily;
import org.openup.core.model.MSContractDiscount;
import org.openup.core.model.X_S_ContractDiscount;

public class MSContract
extends X_S_Contract
implements DocAction,
DocOptions {
    private static final long serialVersionUID = 20181218L;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public MSContract(Properties ctx, int S_Contract_ID, String trxName) {
        super(ctx, S_Contract_ID, trxName);
    }

    public MSContract(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (!MPeriod.isOpen(this.getCtx(), this.getDateDoc(), dt.getDocBaseType(), this.getAD_Org_ID())) {
            this.m_processMsg = "@PeriodClosed@";
            return "IN";
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setDefiniteDocumentNo();
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    private void setDefiniteDocumentNo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateDoc(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete()) {
            String value = null;
            int index = this.p_info.getColumnIndex("C_DocType_ID");
            if (index == -1) {
                index = this.p_info.getColumnIndex("C_DocTypeTarget_ID");
            }
            if (index != -1) {
                value = DB.getDocumentNo(this.get_ValueAsInt(index), this.get_TrxName(), true);
            }
            if (value != null) {
                this.setDocumentNo(value);
            }
        }
    }

    @Override
    public boolean voidIt() {
        this.log.info("voidIt - " + this.toString());
        return this.closeIt();
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.setProcessed(false);
        return true;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return 0;
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return null;
    }

    @Override
    public int customizeValidActions(String docStatus, Object processing, String orderType, String isSOTrx, int AD_Table_ID, String[] docAction, String[] options, int index) {
        if (AD_Table_ID == Table_ID && docStatus.equals("CO")) {
            options[index++] = "RE";
            options[index++] = "VO";
        }
        return index;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MSContract[").append(this.getSummary()).append("]");
        return sb.toString();
    }

    private List<MSContractDiscount> getDiscounts() {
        return new Query(this.getCtx(), "S_ContractDiscount", "S_Contract_ID=?", this.get_TrxName()).setParameters(this.getS_Contract_ID()).list();
    }

    public void updateLinesWithDiscount() {
        List<MSContractDiscount> discounts = this.getDiscounts();
        List mSContractLines = new Query(this.getCtx(), "S_ContractLine", "S_Contract_ID=?", this.get_TrxName()).setParameters(this.getS_Contract_ID()).list();
        for (X_S_ContractLine mSContractLine : mSContractLines) {
            AtomicReference<MProductCategory> mProductCategory = new AtomicReference<MProductCategory>();
            try {
                mProductCategory.set((MProductCategory)mSContractLine.getM_Product().getM_Product_Category());
            }
            catch (Exception exception) {
                // empty catch block
            }
            BigDecimal percentage = Env.ZERO;
            if (mProductCategory.get() != null) {
                percentage = discounts.stream().filter(msContractDiscount -> msContractDiscount.getM_Product_Category_ID() == ((MProductCategory)mProductCategory.get()).get_ID()).map(X_S_ContractDiscount::getDiscount).reduce(Env.ZERO, BigDecimal::add);
            }
            mSContractLine.setDiscount(percentage);
            mSContractLine.saveEx();
        }
    }

    public int setContractDiscount(int discountSchemaId, boolean isForDelete, int mProductCategoryId) {
        int ret = 0;
        List<MSContractDiscount> msContractDiscounts = this.getDiscounts();
        PO msContractDiscount = null;
        for (MSContractDiscount discount : msContractDiscounts) {
            if (discount.getM_DiscountSchema_ID() != discountSchemaId) continue;
            msContractDiscount = discount;
        }
        if (isForDelete) {
            if (msContractDiscount != null) {
                msContractDiscount.deleteEx(true);
                ++ret;
            }
        } else {
            MDiscountSchema mDiscountSchema;
            if (msContractDiscount == null) {
                msContractDiscount = new MSContractDiscount(this);
            }
            if (!"F".equalsIgnoreCase((mDiscountSchema = new MDiscountSchema(this.getCtx(), discountSchemaId, this.get_TrxName())).getDiscountType())) {
                throw new AdempiereException("Debe seleccionar un Porcentaje Simple como Descuento");
            }
            ((X_S_ContractDiscount)msContractDiscount).setDiscount(mDiscountSchema.getFlatDiscount());
            ((X_S_ContractDiscount)msContractDiscount).setM_DiscountSchema_ID(discountSchemaId);
            ((X_S_ContractDiscount)msContractDiscount).setM_Product_Category_ID(mProductCategoryId);
            ((X_S_ContractDiscount)msContractDiscount).setS_Contract_ID(this.getS_Contract_ID());
            msContractDiscount.saveEx();
            ++ret;
        }
        return ret;
    }

    public int createContractDiscounts(int discountSchemaId) {
        MDiscountSchema mDiscountSchema;
        int ret = 0;
        List<MSContractDiscount> msContractDiscounts = this.getDiscounts();
        MSContractDiscount msContractDiscount = null;
        for (MSContractDiscount discount : msContractDiscounts) {
            if (discount.getM_DiscountSchema_ID() != discountSchemaId) continue;
            msContractDiscount = discount;
        }
        if (msContractDiscount == null) {
            msContractDiscount = new MSContractDiscount(this);
        }
        if (!Objects.equals((mDiscountSchema = new MDiscountSchema(this.getCtx(), discountSchemaId, this.get_TrxName())).getDiscountType(), "B")) {
            throw new AdempiereException(mDiscountSchema.getName() + " no es un descuento por Cortes");
        }
        AtomicReference<Integer> qtyChildren = new AtomicReference<Integer>(1);
        try {
            qtyChildren.set(new MFamily(this.getCtx(), this.get_ValueAsInt("UY_Family_ID"), this.get_TrxName()).get_ValueAsInt("QtyUsed"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        List<MDiscountSchemaBreak> mDiscountSchemaBreaks = Arrays.asList(mDiscountSchema.getBreaks(true));
        AtomicReference selectedMDiscountSchemaBreak = new AtomicReference();
        mDiscountSchemaBreaks.stream().sorted(Comparator.comparing(X_M_DiscountSchemaBreak::getBreakValue)).forEach(mDiscountSchemaBreak -> {
            if ((float)((Integer)qtyChildren.get()).intValue() >= mDiscountSchemaBreak.getBreakValue().floatValue()) {
                selectedMDiscountSchemaBreak.set(mDiscountSchemaBreak);
            }
        });
        if (selectedMDiscountSchemaBreak.get() != null) {
            msContractDiscount.setDiscount(((MDiscountSchemaBreak)selectedMDiscountSchemaBreak.get()).getBreakDiscount());
            msContractDiscount.setM_DiscountSchema_ID(discountSchemaId);
            msContractDiscount.setM_Product_Category_ID(((MDiscountSchemaBreak)selectedMDiscountSchemaBreak.get()).getM_Product_Category_ID());
            msContractDiscount.setS_Contract_ID(this.getS_Contract_ID());
            msContractDiscount.saveEx();
            ++ret;
        }
        return ret;
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE S_Contract_ID=" + this.getS_Contract_ID();
        int noLine = DB.executeUpdate("UPDATE S_ContractLine " + set, this.get_TrxName());
        int noTax = DB.executeUpdate("UPDATE S_ContractTax " + set, this.get_TrxName());
        this.log.fine(processed + " - Lines = " + noLine + ", Tax = " + noTax);
    }
}

